/*
 * Senseair S8 LP
 *
 * Auteur: Christophe Boyanique
 * Licence: CC Attribution-Share Alike 4.0 International
 * https://creativecommons.org/licenses/by-sa/4.0/deed.fr
 *
 */
 
vide           = 0.01;
buse_w         = 0.4;
buse_h         = 0.2;
res            = 32;

_s8_l           =  33.5;
_s8_w           =  19.8;
_s8_h           =   8.0;
_s8_pcb_h       =   1.8;
_s8_pcb_l4      =   3.5;
_s8_pcb_w4      =  10.4;
_s8_pcb_l5      =   3.5;
_s8_pcb_w5      =  13.0;
_s8_co2_x       =   0.8;
_s8_co2_y       =   0.8;
_s8_co2_l1      =  17.4;
_s8_co2_l2      =   8.4;
_s8_co2_w1      =  13.0;
_s8_co2_w2      =   7.4;
_s8_co2_h       =   0.4;

hole_pitch =   2.54;
hole_r     =   0.5;
copper_r   =   1.1;
copper_h   =   0.1;

module s8() {

    // plaque
    difference() {
        union() {
            // plaque gauche
            translate([0, (_s8_w-_s8_pcb_w5)/2, 0])
            color("Black", alpha=0.75)
                cube([_s8_pcb_l5, _s8_pcb_w5, _s8_pcb_h]);
            // plaque
            translate([_s8_pcb_l5, 0, 0])
            color("Black", alpha=0.75)
                cube([_s8_l-_s8_pcb_l5-_s8_pcb_l4, _s8_w, _s8_pcb_h]);
            // plaque droite
            translate([_s8_l-_s8_pcb_l4, (_s8_w-_s8_pcb_w5)/2, 0])
            color("Black", alpha=0.75)
                cube([_s8_pcb_l4, _s8_pcb_w4, _s8_pcb_h]);
            // dessous
            translate([_s8_pcb_l5, 0, -_s8_h+_s8_pcb_h])
            color("DarkGray", alpha=0.75)
                cube([_s8_l-_s8_pcb_l5-_s8_pcb_l4, _s8_w, _s8_h-_s8_pcb_h]);
            // capteur
            color("LightSlateGray", alpha=0.75) hull() {
                translate([_s8_l-_s8_pcb_l4-_s8_co2_x-_s8_co2_l1, _s8_co2_y, _s8_pcb_h])
                    cube([1, 1, _s8_co2_h]);
                translate([_s8_l-_s8_pcb_l4-_s8_co2_x-1, _s8_co2_y, _s8_pcb_h])
                    
                    cube([1, 1, _s8_co2_h]);
                translate([_s8_l-_s8_pcb_l4-_s8_co2_x-1, _s8_co2_y+_s8_co2_w1-1, _s8_pcb_h])
                    cube([1, 1, _s8_co2_h]);
                translate([_s8_l-_s8_pcb_l4-_s8_co2_x-_s8_co2_l2, _s8_co2_y+_s8_co2_w1-1, _s8_pcb_h])
                    cube([1, 1, _s8_co2_h]);
                translate([_s8_l-_s8_pcb_l4-_s8_co2_x-_s8_co2_l1, _s8_co2_y+_s8_co2_w2-1, _s8_pcb_h])
                    cube([1, 1, _s8_co2_h]);
            }
            // trous gauche
            for (j=[0:4]) {
                x = _s8_pcb_l5/2;
                y =  (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w5/2 - hole_pitch * (j - 2);
                translate([x, y, -copper_h])
                    color("DarkGoldenrod", alpha=0.75)
                        cylinder(r=copper_r, h=_s8_pcb_h+2*copper_h, $fn=res);
            }
            // trous droite
            for (j=[0:3]) {
                x = _s8_l - _s8_pcb_l4/2;
                y =  (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w4/2 - hole_pitch * (j - 1.5);
                translate([x, y, -copper_h])
                    color("DarkGoldenrod", alpha=0.75)
                        cylinder(r=copper_r, h=_s8_pcb_h+2*copper_h, $fn=res);
            }
        }
        // trous gauche
        for (j=[0:4]) {
            x = _s8_pcb_l5/2;
            y =  (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w5/2 - hole_pitch * (j - 2);
            translate([x, y, -copper_h-vide])
                cylinder(r=hole_r, h=_s8_pcb_h+2*copper_h+2*vide, $fn=res);
        }
        // trous droite
        for (j=[0:3]) {
            x = _s8_l - _s8_pcb_l4/2;
            y =  (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w4/2 - hole_pitch * (j - 1.5);
            translate([x, y, -copper_h-vide])
                cylinder(r=hole_r, h=_s8_pcb_h+2*copper_h+2*vide, $fn=res);
        }
    }
}

function rcm_s8h5_x(i) = _s8_pcb_l4/2;
function rcm_s8h5_y(j) = (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w5/2 - hole_pitch * (j - 2);


function rcm_s8h4_x(i) = _s8_l - _s8_pcb_l4/2;
function rcm_s8h4_y(j) = (_s8_w-_s8_pcb_w5)/2 + _s8_pcb_w4/2 - hole_pitch * (j - 1.5);

//s8();
