/*
 * DYM 16340 shield
 *
 * Auteur: Christophe Boyanique
 * Licence: CC Attribution-Share Alike 4.0 International
 * https://creativecommons.org/licenses/by-sa/4.0/deed.fr
 *
 */
 
s16340_b      =   5.6;
s16340_l      =  60.0;
s16340_w      =  28.2;
s16340_h      =   1.8;
s16340_cr     =   1.6; // rayon coin
s16340usb_l   =  10.0; // port USB
s16340usb_w   =  13.6;
s16340usb_h   =   6.1;
s16340musb_l  =   4.6; // port µUSB
s16340musb_w  =   8.0;
s16340musb_h  =   2.8;
s16340sw_l    =   7.2; // interrupteur
s16340sw_w    =   3.6;
s16340sw_h    =   3.8;
s16340sw_x    =   7.2;
s16340sup_l   =  43.4; // support
s16340sup_w   =  18.4;
s16340sup_h   =  14.2;
s16340sup_x   =  11.0;
s16340accu_l   =  32.8; // accu
s16340accu_w   =   8.2;
s16340accu_r   =   8.2;
s16340accu_x   =  16.8;
s16340accu_y   =   1.4;
s16340t_r      =   1.4; // trous
s16340tl_x     =   2.4/*3.2*/;
s16340tl_y     =   2.4;
s16340tr_x     =   2.4;
s16340tr_y     =   2.4;
s16340leds_l   =   5.0; // accu
s16340leds_w   =   4.0;
s16340leds_h   =   1.4;
s16340leds_y   =   4.4;

function s16340_height() = s16340_h+s16340accu_y+2*s16340accu_r;

module s16340(bottom=true) {

    if (bottom) {
        color("LightSalmon", alpha=0.5)
        %hull() {
            translate([s16340_cr, s16340_cr, -s16340_b])
                cylinder(r=s16340_cr, h=s16340_b, $fn=res);
            translate([s16340_l-s16340_cr, s16340_cr, -s16340_b])
                cylinder(r=s16340_cr, h=s16340_b, $fn=res);
            translate([s16340_l-s16340_cr, s16340_w-s16340_cr, -s16340_b])
                cylinder(r=s16340_cr, h=s16340_b, $fn=res);
            translate([s16340_cr, s16340_w-s16340_cr, -s16340_b])
                cylinder(r=s16340_cr, h=s16340_b, $fn=res);
        }
    }

    difference() {
        // plaque
        color("DarkSalmon", alpha=0.75)
        hull() {
            translate([s16340_cr, s16340_cr, 0])
                cylinder(r=s16340_cr, h=s16340_h, $fn=res);
            translate([s16340_l-s16340_cr, s16340_cr, 0])
                cylinder(r=s16340_cr, h=s16340_h, $fn=res);
            translate([s16340_l-s16340_cr, s16340_w-s16340_cr, 0])
                cylinder(r=s16340_cr, h=s16340_h, $fn=res);
            translate([s16340_cr, s16340_w-s16340_cr, 0])
                cylinder(r=s16340_cr, h=s16340_h, $fn=res);
        }
        // trous gauche
        translate([s16340tl_x, s16340tl_y, -vide])
            cylinder(r=s16340t_r, h=s16340_h+2*vide, $fn=res);
        translate([s16340tl_x, s16340_w-s16340tl_y, -vide])
            cylinder(r=s16340t_r, h=s16340_h+2*vide, $fn=res);
        // trous droite
        translate([s16340_l-s16340tr_x, s16340tr_y, -vide])
            cylinder(r=s16340t_r, h=s16340_h+2*vide, $fn=res);
        translate([s16340_l-s16340tr_x, s16340_w-s16340tr_y, -vide])
            cylinder(r=s16340t_r, h=s16340_h+2*vide, $fn=res);
    }
    // port USB
    translate([0, (s16340_w-s16340usb_w)/2, s16340_h])
        color("DarkSalmon", alpha=0.75)
            cube([s16340usb_l, s16340usb_w, s16340usb_h]);
    // port µUSB
    translate([s16340_l-s16340musb_l, (s16340_w-s16340musb_w)/2, s16340_h])
        color("IndianRed", alpha=0.75)
            cube([s16340musb_l, s16340musb_w, s16340musb_h]);
    // leds
    translate([s16340_l-s16340leds_l, s16340leds_y, s16340_h])
        color("IndianRed", alpha=0.75)
            cube([s16340leds_l, s16340leds_w, s16340leds_h]);
    // interrupteur
    translate([s16340sw_x, s16340_w-s16340sw_w, s16340_h])
        color("IndianRed", alpha=0.75)
            cube([s16340sw_l, s16340sw_w, s16340sw_h]);
    // support
    translate([s16340sup_x, (s16340_w-s16340sup_w)/2, s16340_h])
        color("DarkSalmon", alpha=0.75)
            cube([s16340sup_l, s16340sup_w, s16340sup_h]);
    // accu
    translate([s16340accu_x, s16340_w/2, s16340_h+s16340accu_y+s16340accu_r])
        color("DarkSalmon", alpha=0.75)
            rotate([0, 90, 0])
                cylinder(r=s16340accu_w, h=s16340accu_l, $fn=res);
}
