/*
 * Plaque PCB
 *
 *
 * Auteur original:
 * vland70 (A V) @ thingiverse
 * https://www.thingiverse.com/thing:3238022
 * Licence CC-BY-NC
 * https://creativecommons.org/licenses/by-nc/4.0/
 *
 * Modifications: Christophe Boyanique
 *
 */
 
vide           = 0.01;
buse_w         = 0.4;
buse_h         = 0.2;
res            = 32;

_plq_pitch =   2.54;
hole_r     =   0.5;
copper_r   =   1.1;
copper_h   =   0.1;
edge       =   1.0;
edge_r     =   1.0;

function rcm_plq_x(plq_l, nx, x) = plq_l/2 - _plq_pitch * ((nx-1)/2 - x);
function rcm_plq_y(plq_w, ny, y) = plq_w/2 - _plq_pitch * ((ny-1)/2 - y);

module rcm_plq(plq_l, plq_w, plq_h, nx, ny) {

    difference() {
        union() {
        // plaque
        color("DarkGreen", alpha=0.75)
            cube([plq_l, plq_w, plq_h]);
        for (i=[0:nx-1]) {
            for (j=[0:ny-1]) {
                x = plq_l/2 - _plq_pitch * ((nx-1)/2 - i);
                y = plq_w/2 - _plq_pitch * ((ny-1)/2 - j);
                translate([x, y, -copper_h])
                    color("DarkGoldenrod", alpha=0.75)
                        cylinder(r=copper_r, h=plq_h+2*copper_h, $fn=res);
                }
            }
        }
        // trous coins
        translate([+edge+edge_r, +edge+edge_r, -vide])
            cylinder(r=edge_r, h=plq_h+2*vide, $fn=res);
        translate([plq_l-edge-edge_r, +edge+edge_r, -vide])
            cylinder(r=edge_r, h=plq_h+2*vide, $fn=res);
        translate([plq_l-edge-edge_r, plq_w-edge-edge_r, -vide])
            cylinder(r=edge_r, h=plq_h+2*vide, $fn=res);
        translate([+edge+edge_r, plq_w-edge-edge_r, -vide])
            cylinder(r=edge_r, h=plq_h+2*vide, $fn=res);
        // trous
        for (i=[0:nx-1]) {
            for (j=[0:ny-1]) {
                x = plq_l/2 - _plq_pitch * (i - (nx-1)/2);
                y = plq_w/2 - _plq_pitch * (j - (ny-1)/2);
                translate([x, y, -copper_h-vide])
                    cylinder(r=hole_r, h=plq_h+2*copper_h+2*vide, $fn=res);
            }
        }
    }
}

//rcm_plq(70.4, 30.2, 1.6, 24, 10);
