/*
 * Encodeur rotatif KY-040
 *
 * Auteur: Christophe Boyanique
 * Licence: CC Attribution-Share Alike 4.0 International
 * https://creativecommons.org/licenses/by-sa/4.0/deed.fr
 *
 */
 
vide           = 0.01;
buse_w         = 0.4;
buse_h         = 0.2;
res            = 32;

_ky040_b        =   2.0;
_ky040_l        =  26.4;
_ky040_w        =  19.2;
_ky040_h        =   1.6;
_ky040t_r       =   1.5;
_ky040tl_x      =   4.5;
_ky040tl_y      =   2.5;
_ky040tr_x      =   4.8;
_ky040tr_y      =   2.5;
_ky040base_x    =   4.6;
_ky040base_y    =   5.2;
_ky040base_l    =  12.0;
_ky040base_w    =  12.2;
_ky040base_h    =   7.8;
_ky040lbs_l     =   2.0;
_ky040lbs_w     =   6.8;
_ky040lbs_h     =   2.4;
_ky040rbs_l     =   2.0;
_ky040rbs_w     =   6.8;
_ky040rbs_h     =   2.4;
_ky040dpt_x = 1.6;
_ky040dpt_y = 5.6;
_ky040dpt_l = 2.8;
_ky040dpt_w = 12.8;
_ky040dpt_h = 10.6;
_ky040dpt_b =  2.0;
_ky040dptc_h =  5.2;
_ky040dptc_l =  8.4;
_ky040dptc_lm = 10.4;
_ky040comp_x =   1.6;
_ky040comp_l =  17.2;
_ky040comp_y =   7.2;
_ky040comp_w =   8.0;
_ky040comp_b =   2.0;
_ky040axe_x = _ky040base_x+_ky040base_l/2;
_ky040axe_y = _ky040base_y+_ky040base_w/2;
_ky040axe_r = 3.4;
_ky040axe_h = 7.8;
_ky040ecrou_h = 4.2;
_ky040rtr_x = _ky040axe_x;
_ky040rtr_y = _ky040axe_y;
_ky040rtr_r = 3.0;
_ky040rtr_h = 12.6;
_ky040rtr_hb = 10.0;


module ky040(bottom = false, angle=true, b=false, br=7.5, bh=17) {

    if (bottom) {
    translate([0, 0, -_ky040_b])
        color("LightSalmon", alpha=0.5)
            %cube([_ky040_l, _ky040_w, _ky040_b]);
    }

    difference() {
        // plaque
        color("IndianRed", alpha=0.75)
            cube([_ky040_l, _ky040_w, _ky040_h]);
        // trou gauche
        translate([_ky040tl_x, _ky040tl_y, -vide])
            cylinder(r=_ky040t_r, h=_ky040_h+2*vide, $fn=res);
        // trou droite
        translate([_ky040_l-_ky040tr_x, _ky040tr_y, -vide])
            cylinder(r=_ky040t_r, h=_ky040_h+2*vide, $fn=res);
    }
    // base
    translate([_ky040base_x, _ky040base_y, _ky040_h])
        color("IndianRed", alpha=0.75)
            cube([_ky040base_l, _ky040base_w, _ky040base_h]);
    // côté gauche base
    translate([_ky040base_x-_ky040lbs_l, _ky040base_y+(_ky040base_w-_ky040lbs_w)/2, _ky040_h])
        color("IndianRed", alpha=0.75)
            cube([_ky040lbs_l, _ky040lbs_w, _ky040lbs_h]);
    // côté droite base
    translate([_ky040base_x+_ky040base_l, _ky040base_y+(_ky040base_w-_ky040rbs_w)/2, _ky040_h])
        color("IndianRed", alpha=0.75)
            cube([_ky040rbs_l, _ky040rbs_w, _ky040rbs_h]);
    if (angle) {
        // dupont coudé
/*
_ky040dptc_h =  6.8;
_ky040dptc_l =  8.4;
*/
        translate([_ky040_l-_ky040dpt_x-_ky040dpt_l, _ky040dpt_y, _ky040_h])
            color("DarkSalmon", alpha=0.75)
                cube([_ky040dpt_l, _ky040dpt_w, _ky040dptc_h]);
        translate([_ky040_l-_ky040dpt_x-_ky040dpt_l, _ky040dpt_y, _ky040_h+_ky040dptc_h-_ky040dpt_l])
            color("DarkSalmon", alpha=0.75)
                cube([_ky040dptc_l, _ky040dpt_w, _ky040dpt_l]);
        translate([_ky040_l-_ky040dpt_x-_ky040dpt_l+_ky040dptc_l, _ky040dpt_y, _ky040_h+_ky040dptc_h-_ky040dpt_l])
            color("DarkSalmon", alpha=0.5)
                cube([_ky040dptc_lm, _ky040dpt_w, _ky040dpt_l]);

    } else {
        // dupont droit
        translate([_ky040_l-_ky040dpt_x-_ky040dpt_l, _ky040dpt_y, _ky040_h])
            color("DarkSalmon", alpha=0.75)
                cube([_ky040dpt_l, _ky040dpt_w, _ky040dpt_h]);
    }
    // dupont en dessous
    translate([_ky040_l-_ky040dpt_x-_ky040dpt_l, _ky040dpt_y, -_ky040dpt_b])
        color("DarkSalmon", alpha=0.75)
            cube([_ky040dpt_l, _ky040dpt_w, _ky040dpt_b]);
    // composants en dessous
    translate([0*_ky040_l+_ky040comp_x-0*_ky040comp_l, _ky040comp_y, -_ky040comp_b])
        color("DarkSalmon", alpha=0.75)
            cube([_ky040comp_l, _ky040comp_w, _ky040comp_b]);
    // axe
    translate([_ky040axe_x, _ky040axe_y, _ky040_h+_ky040base_h])
        color("IndianRed", alpha=0.75)
            cylinder(r=_ky040axe_r, h=_ky040axe_h, $fn=res);
    // rotor
    color("IndianRed", alpha=0.75)difference() {
        translate([_ky040rtr_x, _ky040rtr_y, _ky040_h+_ky040base_h+_ky040axe_h])
            
                cylinder(r=_ky040rtr_r, h=_ky040rtr_h, $fn=res);
        translate([_ky040rtr_x+_ky040rtr_r/2, _ky040rtr_y-_ky040rtr_r-vide, _ky040_h+_ky040base_h+_ky040axe_h+_ky040rtr_h-_ky040rtr_hb-0*vide])
            cube([_ky040rtr_r+vide, 2*_ky040rtr_r+2*vide, _ky040rtr_hb+2*vide]);
    }

    if (b) {
    difference() {
        union() {
            translate([_ky040rtr_x, _ky040rtr_y, _ky040_h+_ky040base_h+_ky040axe_h])
            color("DarkSalmon", alpha=0.75)
            cylinder(r=br, h=bh/*_ky040rtr_h-_ky040rtr_hb*/, $fn=res);
/*            translate([_ky040rtr_x, _ky040rtr_y, _ky040_h+_ky040base_h+_ky040axe_h+0*br-vide])
                cylinder(r=_ky040rtr_r+4*buse_w, h=_ky040rtr_h-_ky040rtr_hb+2*vide, $fn=res);*/

        }

        difference() {
            translate([_ky040rtr_x, _ky040rtr_y, _ky040_h+_ky040base_h+_ky040axe_h -vide])
                cylinder(r=_ky040rtr_r+buse_w, h=_ky040rtr_h+2*vide, $fn=res);
            translate([_ky040rtr_x+_ky040rtr_r/2+buse_w, _ky040rtr_y-_ky040rtr_r-vide, _ky040_h+_ky040base_h+_ky040axe_h -vide+_ky040rtr_h-_ky040rtr_hb+2*vide])
                cube([_ky040rtr_r+vide, 2*_ky040rtr_r+0*buse_w+2*vide, _ky040rtr_h+4*vide]);
        }

    }

    }

}

//ky040(false, true, true,7.5, 17);
