/*
 * Lolin/Wemos EPD 13 pouces
 *
 * Auteur: Christophe Boyanique
 * Licence: CC Attribution-Share Alike 4.0 International
 * https://creativecommons.org/licenses/by-sa/4.0/deed.fr
 *
 */
 
vide           = 0.01;
buse_w         = 0.4;
buse_h         = 0.2;
res            = 32;

_epd_pcb_l   = 70.4;  // Largeur PCB
_epd_pcb_w   = 30.4;  // Hauteur PCB
_epd_pcb_t   =  1.2;  // Épaisseur PCB
_epd_scr_x   =  4.8;  // X écran depuis le board PCB
_epd_scr_y   =  0.2;  // Y écran depuis le board PCB
_epd_scr_l   = _epd_pcb_l - 2 * _epd_scr_x;  // W écran
_epd_scr_w   = _epd_pcb_w - 2 * _epd_scr_y;  // H écran
_epd_scr_t  =  1.40;  // Épaisseur écran
_epd_disp_x1 = 13.2;  // X affichage depuis le board PCB
_epd_disp_x2 =  7.2;  // X affichage depuis le board PCB
_epd_disp_y1 =  2.6;  // Y affichage depuis le board PCB
_epd_disp_y2 =  2.6;  // Y affichage depuis le board PCB
_epd_disp_l  = _epd_pcb_l - _epd_disp_x1 - _epd_disp_x2;
_epd_disp_w  = _epd_pcb_w - _epd_disp_y1 - _epd_disp_y2;
_epd_tft_x    = 31.0;
_epd_tft_y    =  7.0;
_epd_tft_l    = 14.8;
_epd_tft_w    = 12.0;
_epd_tft_h    =  4.0;
_epd_tft_b    =  6.0;

_epd_rib_x    =  1.6;
_epd_rib_y    =  5.6;
_epd_rib_l    = 12.6;
_epd_rib_h    =  3.4;

edge         =  1.5;
hole_r       =  0.5;
copper_r     =  1.1;
copper_h     =  0.1;

module rcm_epd() {

    // Écran
    translate([_epd_scr_x, 0, _epd_scr_y])
        color("White")
            cube([_epd_scr_l, _epd_scr_t, _epd_scr_w]);
    difference() {
        translate([_epd_disp_x1, -vide, _epd_disp_y1])
            color("Black")
                cube([_epd_disp_l, 2*vide, _epd_disp_w]);
        translate([_epd_disp_x1+buse_h, -2*vide, _epd_disp_y1+buse_h])
            color("Black")
                cube([_epd_disp_l-2*buse_h, 3*vide, _epd_disp_w-2*buse_h]);

    }

    // Plaque
    difference() {
        union() {
            translate([0, _epd_scr_t, 0])
                color("DarkBlue")
                    cube([_epd_pcb_l, _epd_pcb_t, _epd_pcb_w], center=false);
            translate([+edge+hole_r, _epd_scr_t+_epd_pcb_t+copper_h, +edge+hole_r])
                rotate([90,0,0])
                    color("DarkGoldenrod")
                        cylinder(r=copper_r, h=_epd_pcb_t+2*copper_h, $fn=res);
            translate([_epd_pcb_l-edge-hole_r, _epd_scr_t+_epd_pcb_t+copper_h, +edge+hole_r])
                rotate([90,0,0])
                    color("DarkGoldenrod")
                        cylinder(r=copper_r, h=_epd_pcb_t+2*copper_h, $fn=res);
            translate([_epd_pcb_l-edge-hole_r, _epd_scr_t+_epd_pcb_t+copper_h, _epd_pcb_w-edge-hole_r])
                rotate([90,0,0])
                    color("DarkGoldenrod")
                        cylinder(r=copper_r, h=_epd_pcb_t+2*copper_h, $fn=res);
            translate([+edge+hole_r, _epd_scr_t+_epd_pcb_t+copper_h, _epd_pcb_w-edge-hole_r])
                rotate([90,0,0])
                    color("DarkGoldenrod")
                        cylinder(r=copper_r, h=_epd_pcb_t+2*copper_h, $fn=res);
        }
        translate([+edge+hole_r, _epd_scr_t+_epd_pcb_t+copper_h+vide, +edge+hole_r])
            rotate([90,0,0])
                cylinder(r=hole_r, h=_epd_pcb_t+2*copper_h+2*vide, $fn=res);
        translate([_epd_pcb_l-edge-hole_r, _epd_scr_t+_epd_pcb_t+copper_h+vide, +edge+hole_r])
            rotate([90,0,0])
                cylinder(r=hole_r, h=_epd_pcb_t+2*copper_h+2*vide, $fn=res);
        translate([_epd_pcb_l-edge-hole_r, _epd_scr_t+_epd_pcb_t+copper_h+vide, _epd_pcb_w-edge-hole_r])
            rotate([90,0,0])
                cylinder(r=hole_r, h=_epd_pcb_t+2*copper_h+2*vide, $fn=res);
        translate([+edge+hole_r, _epd_scr_t+_epd_pcb_t+copper_h+vide, _epd_pcb_w-edge-hole_r])
            rotate([90,0,0])
                cylinder(r=hole_r, h=_epd_pcb_t+2*copper_h+2*vide, $fn=res);
    }


    // Prise TFT
    translate([_epd_tft_x, _epd_scr_t+_epd_pcb_t, -_epd_tft_b])
        cube([_epd_tft_l, _epd_tft_h, _epd_tft_b+_epd_tft_h]);

    // Nappe
    translate([_epd_rib_x, _epd_scr_t+_epd_pcb_t, _epd_rib_y])
        cube([_epd_rib_l, _epd_rib_h, _epd_pcb_w-2*_epd_rib_y]);
    translate([_epd_rib_x, 0, _epd_rib_y])
        cube([_epd_scr_x-_epd_rib_x, _epd_scr_t, _epd_pcb_w-2*_epd_rib_y]);

    // Prise Dupond
    /*translate([_epd_pcb_w-18.8, _epd_scr_t+_epd_pcb_t, 4.2])
        cube([18.8, 12, _epd_pcb_l-2*4.2], center=false);*/

    // Composants
    translate([18.8, _epd_scr_t+_epd_pcb_t, 4.0])
        cube([12.8, 3.0, _epd_pcb_w-4.0-3.0], center=false);

}

//rcm_epd();
