/*
 * Connecteurs Dupont femelles
 *
 *
 * Auteur original:
 * vland70 (A V) @ thingiverse
 * https://www.thingiverse.com/thing:3238022
 * Licence CC-BY-NC
 * https://creativecommons.org/licenses/by-nc/4.0/
 *
 * Modifications: Christophe Boyanique
 *
 */
 
$fn=36;

module dupontm(pitch, nmb, solder, ep, picot_h, body_h, male_h) {

    for(a=[0:1:nmb-1]) {
        color("Goldenrod")
            translate([pitch*a-0.3, -0.3, -picot_h])
                cube([0.6, 0.6, picot_h+body_h+male_h]);
         color("DarkSlateGray")
            translate([pitch*a, 0, 0])
               connector(2.10, 2, body_h);
        if(solder==1) {
            color("Silver")
            translate([pitch*a, 0, -ep-1])
                cylinder(r1=0, r2=1, h=1);
        }
    }
}

module dupontf(pitch, nmb, solder, ep, picot_h, body_h) {

    for(a=[0:1:nmb-1]) {
        color("Goldenrod")
            translate([pitch*a-0.3, -0.3, -picot_h])
                cube([0.6, 0.6, picot_h]);
        if(solder==1) {
            color("Silver")
            translate([pitch*a, 0, -ep-1])
                cylinder(r1=0, r2=1, h=1);
        }
        difference() {
         color("DarkSlateGray")
            translate([pitch*a, 0, 0])
               connector(2.55, 2, body_h);
          color("grey")
            translate([pitch*a, 0, 0+2])
               connector(1.25,1.25, body_h);
          }

      }
}

module connector(x, y, z) {
    hull() {
        translate([x/2, y/2, 0.25])
            sphere(r=0.25,$fn=18);
        translate([-x/2, y/2, 0.25])
            sphere(r=0.25,$fn=18);
        translate([x/2, -y/2, 0.25])
            sphere(r=0.25,$fn=18);
        translate([-x/2, -y/2, 0.25])
            sphere(r=0.25,$fn=18);

        translate([x/2, y/2, z-0.25])
            sphere(r=0.25,$fn=18);
        translate([-x/2, y/2, z-0.25])
            sphere(r=0.25,$fn=18);
        translate([x/2, -y/2, z-0.25])
            sphere(r=0.25,$fn=18);
        translate([-x/2, -y/2, z-0.25])
            sphere(r=0.25,$fn=18);
    }
}
/*
translate([0, 0, 0])
    dupontf(2.54, 6, 1, 1.2, 3, 8.4);

translate([20, 0, 0])
    dupontm(2.54, 6, 1, 1.2, 3, 2.4, 6);
*/