/*
 * Lolin/Wemos D32 PRO v2
 *
 * Auteur: Christophe Boyanique
 * Licence: CC Attribution-Share Alike 4.0 International
 * https://creativecommons.org/licenses/by-sa/4.0/deed.fr
 *
 */
 
vide           = 0.01;
buse_w         = 0.4;
buse_h         = 0.2;
res            = 32;

_d32pro_b      =   2.0;
_d32pro_l      =  65.4;
_d32pro_w      =  25.4;
_d32pro_h      =   1.0;
_d32pro_cr     =   1.6; // rayon coin

_d32pro_edge   =   0.95;
_d32pro_hole_r =   1.05;

_d32promusb_l  =   5.8; // port µUSB
_d32promusb_w  =   7.8;
_d32promusb_h  =   2.8;
_d32promusb_y  =  10.0;

_d32probatt_l  =   6.0; // port i2c
_d32probatt_w  =   6.2;
_d32probatt_h  =   5.6;
_d32probatt_x  =   2.4;

_d32proi2c_l  =   7.0; // port i2c
_d32proi2c_w  =   4.4;
_d32proi2c_h  =   3.2;
_d32proi2c_x  =  11.4;

_d32prosd_l  =  11.4; // port sdcard
_d32prosd_w  =   5.8;
_d32prosd_h  =   2.6;
_d32prosd_x  =   6.2;

hole_pitch =   2.54;
hole_r     =   0.5;
copper_r   =   1.1;
copper_h   =   0.1;

function _d32pro_height() = _d32pro_h+_d32proaccu_y+2*_d32proaccu_r;

module d32pro(bottom=false) {

    if (bottom) {
        color("LightSalmon", alpha=0.5) %hull() {
            translate([_d32pro_cr, _d32pro_cr, -_d32pro_b])
                cylinder(r=_d32pro_cr, h=_d32pro_b, $fn=res);
            translate([_d32pro_l-_d32pro_cr, _d32pro_cr, -_d32pro_b])
                cylinder(r=_d32pro_cr, h=_d32pro_b, $fn=res);
            translate([_d32pro_l-_d32pro_cr, _d32pro_w-_d32pro_cr, -_d32pro_b])
                cylinder(r=_d32pro_cr, h=_d32pro_b, $fn=res);
            translate([_d32pro_cr, _d32pro_w-_d32pro_cr, -_d32pro_b])
                cylinder(r=_d32pro_cr, h=_d32pro_b, $fn=res);
        }
    }
    difference() {
        union() {
            // plaque
            color("DarkSalmon", alpha=0.75)
            hull() {
                translate([_d32pro_cr, _d32pro_cr, 0])
                    cylinder(r=_d32pro_cr, h=_d32pro_h, $fn=res);
                translate([_d32pro_l-_d32pro_cr, _d32pro_cr, 0])
                    cylinder(r=_d32pro_cr, h=_d32pro_h, $fn=res);
                translate([_d32pro_l-_d32pro_cr, _d32pro_w-_d32pro_cr, 0])
                    cylinder(r=_d32pro_cr, h=_d32pro_h, $fn=res);
                translate([_d32pro_cr, _d32pro_w-_d32pro_cr, 0])
                    cylinder(r=_d32pro_cr, h=_d32pro_h, $fn=res);
            }
            // trous bas
            for (j=[0:15]) {
                y =  1.28;
                x =  7.3 + j * hole_pitch;
                translate([x, y, -copper_h])
                    color("DarkGoldenrod", alpha=0.75)
                        cylinder(r=copper_r, h=_d32pro_h+2*copper_h, $fn=res);
            }
            // trous haut
            for (j=[0:15]) {
                y =  _d32pro_w - 1.28;
                x =  7.3 + j * hole_pitch;
                translate([x, y, -copper_h])
                    color("DarkGoldenrod", alpha=0.75)
                        cylinder(r=copper_r, h=_d32pro_h+2*copper_h, $fn=res);
            }
        }
        // trous
        translate([_d32pro_edge+_d32pro_hole_r, _d32pro_edge+_d32pro_hole_r, -vide])
            cylinder(r=_d32pro_hole_r, h=_d32pro_h+2*vide, $fn=res);
        translate([_d32pro_edge+_d32pro_hole_r, _d32pro_w-_d32pro_edge-_d32pro_hole_r, -vide])
        cylinder(r=_d32pro_hole_r, h=_d32pro_h+2*vide, $fn=res);
        // trous bas
        for (j=[0:15]) {
            y =  1.28;
            x =  7.3 + j * hole_pitch;
            translate([x, y, -copper_h-vide])
                cylinder(r=hole_r, h=_d32pro_h+2*copper_h+2*vide, $fn=res);
        }
        // trous haut
        for (j=[0:15]) {
            y =  _d32pro_w - 1.28;
            x =  7.3 + j * hole_pitch;
            translate([x, y, -copper_h-vide])
                cylinder(r=hole_r, h=_d32pro_h+2*copper_h+2*vide, $fn=res);
        }
    }

    // port µUSB
    translate([_d32pro_l-_d32promusb_l, _d32promusb_y, _d32pro_h])
        color("IndianRed", alpha=0.75)
            cube([_d32promusb_l, _d32promusb_w, _d32promusb_h]);

    // port batt
    translate([_d32pro_l-_d32probatt_l-_d32probatt_x, 0, _d32pro_h])
        color("IndianRed", alpha=0.75)
            cube([_d32probatt_l, _d32probatt_w, _d32probatt_h]);

    // port i2c
    translate([_d32pro_l-_d32proi2c_l-_d32proi2c_x, 0, _d32pro_h])
        color("IndianRed", alpha=0.75)
            cube([_d32proi2c_l, _d32proi2c_w, _d32proi2c_h]);

    // port sdcard
    translate([_d32pro_l-_d32prosd_l-_d32prosd_x, _d32pro_w-_d32prosd_w, _d32pro_h])
        color("IndianRed", alpha=0.75)
            cube([_d32prosd_l, _d32prosd_w, _d32prosd_h]);


/*
    // port USB
    translate([0, (_d32pro_w-_d32prousb_w)/2, _d32pro_h])
        color("DarkSalmon", alpha=0.5)
            cube([_d32prousb_l, _d32prousb_w, _d32prousb_h]);
    // port µUSB
    translate([_d32pro_l-_d32promusb_l, (_d32pro_w-_d32promusb_w)/2, _d32pro_h])
        color("IndianRed", alpha=0.5)
            cube([_d32promusb_l, _d32promusb_w, _d32promusb_h]);
    // leds
    translate([_d32pro_l-_d32proleds_l, _d32proleds_y, _d32pro_h])
        color("IndianRed", alpha=0.5)
            cube([_d32proleds_l, _d32proleds_w, _d32proleds_h]);
    // interrupteur
    translate([_d32prosw_x, _d32pro_w-_d32prosw_w, _d32pro_h])
        color("IndianRed", alpha=0.5)
            cube([_d32prosw_l, _d32prosw_w, _d32prosw_h]);
    // support
    translate([_d32prosup_x, (_d32pro_w-_d32prosup_w)/2, _d32pro_h])
        color("DarkSalmon", alpha=0.5)
            cube([_d32prosup_l, _d32prosup_w, _d32prosup_h]);
    // accu
    translate([_d32proaccu_x, _d32pro_w/2, _d32pro_h+_d32proaccu_y+_d32proaccu_r])
        color("DarkSalmon", alpha=0.5)
            rotate([0, 90, 0])
                cylinder(r=s16340accu_w, h=s16340accu_l, $fn=res);
*/
}


function rcm_d32pro_hb_x(i) = 7.3 + i * hole_pitch;
function rcm_d32pro_hb_y(i) = 1.28;
function rcm_d32pro_ht_x(i) = 7.3 + i * hole_pitch;
function rcm_d32pro_ht_y(j) = _d32pro_w - 1.28;

//d32pro();
